rule Win32_Ransomware_Velso : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "VELSO"
        description         = "Yara rule that detects Velso ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Velso"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 89 E5 81 EC ?? ?? ?? ?? 8D 45 ?? 89 A5 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 75 ?? C6 85 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? 89 04 24 E8 ?? ?? ?? ?? 0F B6 85 ?? ?? ?? ?? C9 C3 C7 04 24 ?? ?? ?? ?? 8B 4D ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 74 ?? C7 04 24 ?? ?? ?? 
            ?? 8B 4D ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 74 ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? 
            ?? ?? ?? 83 EC ?? 85 C0 74 ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 83 EC ?? 
            85 C0 74 ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 0F 84 ?? ?? 
            ?? ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 0F 84 ?? ?? ?? ?? 
            C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 0F 84 ?? ?? ?? ?? C7 04 
            24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 85 C0 51 0F 84 ?? ?? ?? ?? C7 04 24 ?? ?? ?? 
            ?? 8B 4D ?? E8 ?? ?? ?? ?? 85 C0 52 0F 84 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? 
            E8 ?? ?? ?? ?? 85 C0 51 0F 84 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? 
            ?? 85 C0 52 0F 84 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? 
            ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 04 24 8B 4D ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 51 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 39 D0 74 ?? 89 
            04 24 E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 
            89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 44 24
        }

        $find_files_p2 = {
            8B 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 52 52 8D 95 
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 
            EB ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 52 52 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 51 51 74 ?? 
            8D 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 52 52 74 ?? 
            F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 4D ?? 89 85 ?? ?? ?? ?? 
            8B 45 ?? 8B 51 ?? 8D 8D ?? ?? ?? ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 51 51 89 44 24 ?? 8B 45 ?? 89 44 24 
            ?? 8D 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 89 44 24 ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 39 D0 74 ?? 89 04 
            24 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 39 D0 0F 84 ?? ?? ?? ?? 89 04 
            24 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? 8B 45 ?? 89 44 24 ?? 
            8D 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 89 
            44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 
            ?? 83 C5 ?? 83 BD ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 0F 87 ?? ?? ?? 
            ?? 8B 85 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 E8
        }

        $enum_resources_p1 = {
            55 89 E5 81 EC ?? ?? ?? ?? 8D 45 ?? 89 65 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? 89 45 ?? 8D 45 ?? 89 04 24 E8 ?? ?? ?? ?? 8D 45 ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 44 24 ?? 8B 45 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 
            24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 89 44 24 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 83 EC ?? 85 C0 74 ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 
            ?? C9 C2 ?? ?? 8B 45 ?? C7 04 24 ?? ?? ?? ?? 89 44 24 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 83 EC ?? 85 C0 89 85 ?? ?? ?? ?? 74 ?? 90 8D B4 26 ?? ?? ?? ?? 8B 45 ?? C7 
            44 24 ?? ?? ?? ?? ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 55 ?? 
            89 54 24 ?? 8B 85 ?? ?? ?? ?? 8D 55 ?? 89 54 24 ?? 89 44 24 ?? 8B 45 ?? 89 04 24 C7 
            45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 74 ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 
            45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 EC ?? 89 04 24 E8 ?? ?? ?? ?? 83 EC ?? 
            85 C0 0F 94 C0 0F B6 C0 89 45 ?? E9 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B
        }

        $enum_resources_p2 = {
            85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 45 ?? EB ?? 8B 45 ?? 8B 40 ?? 89 85 
            ?? ?? ?? ?? 83 E0 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 83 85 ?? ?? ?? ?? ?? 83 45 ?? ?? 8B 
            85 ?? ?? ?? ?? 39 45 ?? 0F 86 ?? ?? ?? ?? 8B 45 ?? F6 40 ?? ?? 74 ?? 8D 45 ?? 8B 4D 
            ?? 89 45 ?? 8B 45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? 83 EC ?? 89 44 24 ?? 8B 45 ?? 89 44 24 ?? 8B 45 ?? 
            89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 8D 55 ?? 83 EC ?? 39 D0 0F 84 
            ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 8D 45 ?? 8B 
            4D ?? 89 45 ?? 8B 45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 EC ?? 8B 40 ?? 89 C2 89 85 ?? ?? ?? ?? 8D 45 
            ?? 85 D2 89 45 ?? B8 ?? ?? ?? ?? 74 ?? 89 14 24 E8 ?? ?? ?? ?? 03 85 ?? ?? ?? ?? 89 
            44 24 ?? 8B 85 ?? ?? ?? ?? 8D 4D ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            45 ?? 83 EC ?? 89 44 24 ?? 8B 45 ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8B 45 ?? 8D 55 ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8D 
            55 ?? 39 D0 0F 84 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9
        }

        $encrypt_files_p1 = {
            55 89 E5 81 EC ?? ?? ?? ?? 8D 45 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 A5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            C6 45 ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 
            45 ?? ?? C7 45 ?? ?? ?? ?? ?? 03 48 ?? 89 85 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 45 ?? ?? 
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 01 C7 04 24 ?? ?? ?? ?? C7 85 
            ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 83 EC ?? C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 4D ?? 83 EC ?? 89 85 ?? ?? ?? ?? 8B 45 ?? 8B 51 ?? 8D 
            8D ?? ?? ?? ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? B8 ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 83 EC ?? 83 F8 ?? 0F 86 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 83 EC ?? 8D 8D ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 8D 8D ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 03 48 ?? C7 04 24 ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 83 EC ?? 39 D0 
            74 ?? 89 04 24 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8B
        }

        $encrypt_files_p2 = {
            40 ?? 89 44 24 ?? 8B 45 ?? 8B 00 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 
            ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 40 ?? 89 94 05 ?? ?? ?? ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C9 C3 03 48 ?? 8B 41 ?? 83 C8 ?? 89 04 24 C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? 
            ?? 03 48 ?? 8B 41 ?? 83 C8 ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            83 EC ?? E9 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 C5 ?? 83 BD ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 77 ?? 8B 85 
            ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 0F 0B 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 39 D0 74 
            ?? 89 04 24 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 15 ?? ?? 
            ?? ?? 8B 40 ?? 89 94 05 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85
        }

        $encrypt_files_p3 = {
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? 
            ?? ?? 8B 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 40 ?? 89 94 05 ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 
            04 24 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D B4 26 ?? ?? ?? ?? 55 89 E5 81 
            EC ?? ?? ?? ?? 8D 45 ?? 89 65 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? 89 45 ?? 8D 45 ?? 89 04 24 E8 ?? ?? ?? ?? 8D 45 ?? 8B 4D ?? 89 45 ?? 8B 
            45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 45 ?? 83 EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 4D ?? C7 04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 
            8B 45 ?? 8D 55 ?? 83 EC ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8D 55 ?? 39
        }

        $encrypt_files_p4 = {
            D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 55 ?? 85 D2 75 ?? C6 45 ?? ?? 8D 45 ?? 89 04 24 
            E8 ?? ?? ?? ?? 0F B6 45 ?? C9 C3 8D 45 ?? 8B 4D ?? 89 45 ?? 8B 45 ?? 8B 51 ?? 8D 4D 
            ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? 83 
            EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? C7 
            04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 8D 55 ?? 83 
            EC ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8D 4D ?? 39 C8 74 ?? 89 04 24 E8 
            ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 8B 4D ?? 89 45 ?? 8B 45 ?? 8B 
            51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 45 ?? 83 EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 4D ?? C7 04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 
            8D 55 ?? 83 EC ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8D 55 ?? 39 D0 74 ?? 
            89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 8B 4D ?? 89 45
        }

        $encrypt_files_p5 = {
            8B 45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 45 ?? 83 EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 4D ?? C7 04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 
            ?? 8B 45 ?? 8D 55 ?? 83 EC ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 8D 55 ?? 
            39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 8B 4D 
            ?? 89 45 ?? 8B 45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? C7 45 ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? 83 EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 C7 45 ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? C7 04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 89 45 ?? 8B 45 ?? 8D 55 ?? 83 EC ?? 39 D0 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 
            ?? 8D 4D ?? 39 C8 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 
            45 ?? 8B 4D ?? 89 45 ?? 8B 45 ?? 8B 51 ?? 8D 4D ?? 8B 00 01 C2 89 04 24 89 54 24 ?? 
            C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? 83 EC ?? 89 44 24 ?? 8D 45 ?? 89 04 24 
            C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? C7 04 24 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 8D 4D ?? 83 EC ?? 39 C8 74 ?? 89 04 24 E8 ?? ?? 
            ?? ?? 8B 45 ?? 8D 4D ?? 39 C8 74 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? 
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
        }

        $encrypt_files_p6 = {
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 8B 00 
            89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 83 F8 ?? 89 85 ?? ?? ?? ?? 0F 
            84 ?? ?? ?? ?? 8D 4D ?? 89 04 24 89 4C 24 ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 EC ?? 3D ?? 
            ?? ?? ?? 77 ?? 83 E0 ?? 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 45 ?? ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 83 EC ?? E9 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 
            ?? 89 04 24 E8 ?? ?? ?? ?? 8D 55 ?? C7 44 24 ?? ?? ?? ?? ?? 89 C1 89 54 24 ?? 8B 45 
            ?? 89 44 24 ?? 89 8D ?? ?? ?? ?? 89 4C 24 ?? 8B 95 ?? ?? ?? ?? 89 14 24 C7 45 ?? ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 83 EC ?? 3B 55 ?? 89 95 ?? ?? ?? ?? 0F 85 ?? ?? ?? 
            ?? 8B 45 ?? 8B 8D ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C1 E8 ?? 89 8D ?? ?? ?? ?? 85 C0 
            89 85 ?? ?? ?? ?? 74 ?? 8B 45 ?? 89 44 24 ?? 8B 85 ?? ?? ?? ?? 89 44 24 ?? 89 85 ?? 
            ?? ?? ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 45 ?? ?? 83 85 ?? ?? ?? ?? 
            ?? 8B 55 ?? 39 95 ?? ?? ?? ?? 75 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24
        }

        $encrypt_files_p7 = {
            C7 44 24 ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 4D ?? 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? 89 4C 24 ?? 8B 8D ?? ?? ?? ?? 89 4C 24 
            ?? 8B 95 ?? ?? ?? ?? 89 54 24 ?? 8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8B 8D ?? 
            ?? ?? ?? 83 EC ?? 3B 4D ?? 74 ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 51 8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 95 ?? ?? 
            ?? ?? 89 14 24 E8 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 89 0C 24 E8 ?? ?? ?? ?? C6 45 ?? 
            ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 04 24 C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 52 
            8B 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 44 24 
            ?? 8D 45 ?? 89 04 24 E8 ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8B 45 ?? 8B 00 89 04 24 C7 
            45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 50 8D 4D ?? 8B 45 ?? 39 C8 74 ?? 89 04 24 E8 ?? 
            ?? ?? ?? C6 45 ?? ?? E9 ?? ?? ?? ?? 89 45 ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($enum_resources_p*)
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}